import { View, FlatList, StyleSheet} from "react-native";
import React from "react";
import SkeletonElement from "../../SkeletonElement";
import dpr from "../../../../screens/Utilities/CustomStyleAttribute/dpr";
import AddressStyle from "../../../../screens/Profile/Address/AddressStyle";

const RenderItem = ({ item }) => {
    return (
        <View style={AddressStyle.singleAddressCont}>
            <SkeletonElement wrapperStyle={styles.skeletonWrapper(20, 150)}/>
            <View style={styles.skeletonElementContainer} >
                <SkeletonElement wrapperStyle={styles.skeletonWrapper(12, 280)} />
                <SkeletonElement wrapperStyle={styles.skeletonWrapper(12, 280)} />
            </View>
            <View style={styles.marginVertical}>
                <SkeletonElement  wrapperStyle={styles.skeletonWrapperStyle} />
                <SkeletonElement wrapperStyle={styles.AddressSkeletonStyle5}/>
            </View>
            <SkeletonElement wrapperStyle={styles.AddressSkeletonStyle6}/>
        </View>
    );
};

const AddressSkeleton = () => {
    return (
        <View style={AddressStyle.container}>
            <FlatList
                data={[1, 2, 3]}
                renderItem={({ item }) => <RenderItem item={item} />}
                keyExtractor={(_, i) => `key-${i}`}
                showsVerticalScrollIndicator={false}
            />
        </View>
    );
};

export default AddressSkeleton;


const styles = StyleSheet.create({
    skeletonWrapper: (height, minusWidth) => ({
        height: dpr(height),
        width: dpr("wf") - dpr(minusWidth),
    }),
    skeletonWrapperStyle:{
        height: dpr(12),
    },
    skeletonElementContainer: {
        flexDirection: "row",
        justifyContent: "space-between",
        marginTop: dpr(10),
    },
    marginVertical: {
        marginVertical: dpr(10)
    },
});
